<?php

namespace AgeGate\UserRegistration\Integration;

use AgeGate\UserRegistration\Settings\Settings;
use AgeGate\Common\Settings as CoreSettings;


abstract class AbstractIntegration
{
    public function fields()
    {
        $settings = Settings::getInstance();

        if (!$settings->restrictRegister) {
            return;
        }

        $core = CoreSettings::getInstance();

        $this->render($settings, $core);
    }

    protected function render($settings, $core, $message = true)
    {

        global $bp, $pagenow;

        if ($bp->signup->errors['age_gate'] ?? false) {
            echo '<div class="bp-messages bp-feedback error"><p>' .  $bp->signup->errors['age_gate'] . '</p></div>';
        }



        $userId = (is_admin() && $pagenow === 'user-edit.php' && current_user_can('edit_users')) ? ((int) $_GET['user_id'] ?? 0) : get_current_user_id();
        $dob = $_POST['age_gate'] ?? get_user_meta($userId, 'user_dob', true ) ?: [];

        echo '<fieldset class="age-gate__registration">';
        echo "<legend>" . __("Date of birth", 'age-gate-user-registration') . "</legend>";

        if ($core->inputType === 'selects') {
            $years = collect(range(apply_filters('age_gate/form/select/year/min', 1900), 2022))->mapWithKeys(function ($year) {
                return[$year => $year];
            });

            if ($core->yearOrder === 'high-low') {
                $years = $years->reverse()->toArray();
            } else {
                $years = $years->toArray();
            }

            include AGE_GATE_USER_REGISTRATION_PATH . 'src/Resources/views/selects.php';
        } else {
            include AGE_GATE_USER_REGISTRATION_PATH . 'src/Resources/views/inputs.php';
        }

        if ($message) {
            if ($settings->storeDob) {
                echo '<small>' . __('Your date of birth will be stored against your profile', 'age-gate-user-registration') . '</small>';
            } else {
                echo '<small>' . __('Your date of birth will not be stored against your profile', 'age-gate-user-registration') . '</small>';
            }
        }
        echo "</fieldset>";
    }

    protected function validation()
    {

    }
}
